/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.ConstOperand;
import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.Expr;
import ibm.nways.analysis.dpEngine.IfThenElse;
import ibm.nways.analysis.dpEngine.IllegalInsertException;
import ibm.nways.analysis.dpEngine.InvalidExpressionException;
import ibm.nways.analysis.dpEngine.NeedInsertException;
import ibm.nways.analysis.dpEngine.OiList;
import ibm.nways.analysis.dpEngine.Operand;
import ibm.nways.analysis.dpEngine.Operator;
import ibm.nways.analysis.dpEngine.Token;
import ibm.nways.analysis.dpEngine.UnaryOperator;
import ibm.nways.jdm.common.Counter;
import ibm.nways.jdm.common.Counter64;
import ibm.nways.jdm.common.Gauge;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Expression {
    private static final int OI = 0;
    private static final int OPERATOR = 1;
    private Expr exprTree;
    private OiList oiList;
    private char[] characters;
    private int currentPos;
    private Expr expression;
    public String defaultIndex;

    public static void main(String[] stringArray) {
        if (stringArray.length != 0) {
            Object[] objectArray = new Counter[5];
            Object[] objectArray2 = new Counter[]{new Counter(10L), new Counter(20L), new Counter(30L), new Counter(40L), new Counter(50L)};
            objectArray[0] = new Counter(5L);
            objectArray[1] = new Counter(15L);
            objectArray[2] = new Counter(25L);
            objectArray[3] = new Counter(35L);
            objectArray[4] = new Counter(45L);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("insert1", "1.2.3");
            hashtable.put("insert2", "12");
            hashtable.put("insert3", "9.67.222.98");
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], ",");
            OiList oiList = new OiList(stringArray[0]);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    Expression expression = new Expression(stringTokenizer.nextToken(), oiList, hashtable);
                    System.out.println("Expr String:" + stringArray[0] + "\n");
                    expression.printTree();
                    System.out.println("the value is: " + expression.evaluate(objectArray2, objectArray, 3000L, 1000L));
                    int n = 0;
                    while (n < expression.oiList.getOIcount()) {
                        System.out.println(expression.oiList.elementAt(n));
                        ++n;
                    }
                    expression.oiList.setWildcardVsScalar();
                    System.out.println("scalar count=" + expression.oiList.getScalarOIcount() + ", wildcards=" + expression.oiList.getWildcardOIcount());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public Expression(String string, Hashtable hashtable) throws NeedInsertException, IllegalInsertException, InvalidExpressionException {
        this.initialize(string, null, hashtable);
    }

    public Expression(String string, OiList oiList, Hashtable hashtable) throws NeedInsertException, IllegalInsertException, InvalidExpressionException {
        this.initialize(string, oiList, hashtable);
    }

    private void initialize(String string, OiList oiList, Hashtable hashtable) throws NeedInsertException, IllegalInsertException, InvalidExpressionException {
        this.oiList = oiList == null ? new OiList(string) : oiList;
        this.initializeTokenizer(string);
        this.expression = this.buildTree(hashtable);
        this.characters = null;
        if (DpInterfaceImpl.trace_expression) {
            DpInterfaceImpl.LogMessage("Creating new expression. String : " + string);
            this.printTree();
        }
    }

    public float calculate(Object[] objectArray, Object[] objectArray2, long l, long l2) {
        float f;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("Expression: evaluating expr:" + this.expression.toString());
            int n = 0;
            while (n < objectArray.length) {
                DpInterfaceImpl.LogMessage("Expression: value#" + n + ", val=" + objectArray[n] + ", oldVal=" + objectArray2[n]);
                ++n;
            }
        }
        if (this.expression == null) {
            DpInterfaceImpl.LogMessage("Expression:calculate() called for null Expression");
            f = Float.NEGATIVE_INFINITY;
        } else {
            Serializable serializable;
            f = objectArray == null ? Float.NEGATIVE_INFINITY : ((serializable = this.expression.Evaluate(objectArray, objectArray2, l, l2)) == null ? Float.NEGATIVE_INFINITY : (serializable instanceof Float ? ((Float)serializable).floatValue() : (serializable instanceof Counter ? (float)((Counter)serializable).value : (serializable instanceof Gauge ? (float)((Gauge)serializable).value : (serializable instanceof Integer ? ((Integer)serializable).floatValue() : (serializable instanceof Counter64 ? (float)((Counter64)serializable).value : Float.NEGATIVE_INFINITY))))));
        }
        if (DpInterfaceImpl.trace_expression) {
            if (f == Float.POSITIVE_INFINITY) {
                DpInterfaceImpl.LogMessage("++++ INFINITE VALUE\n  " + this.expression.toString());
                int n = 0;
                while (n < objectArray.length) {
                    DpInterfaceImpl.LogMessage("Expression: value#" + n + ", val=" + objectArray[n] + ", oldVal=" + objectArray2[n]);
                    ++n;
                }
            }
            if (Float.isNaN(f)) {
                DpInterfaceImpl.LogMessage("---- NaN VALUE\n  " + this.expression.toString());
                int n = 0;
                while (n < objectArray.length) {
                    DpInterfaceImpl.LogMessage("Expression: value#" + n + ", val=" + objectArray[n] + ", oldVal=" + objectArray2[n]);
                    ++n;
                }
            }
        }
        return f;
    }

    public Serializable evaluate(Object[] objectArray, Object[] objectArray2, long l, long l2) {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("evaluating expr:" + this.expression.toString());
            int n = 0;
            while (n < objectArray.length) {
                DpInterfaceImpl.LogMessage("Expression: value#" + n + ", val=" + objectArray[n] + ", oldVal=" + objectArray2[n]);
                ++n;
            }
        }
        if (this.expression == null) {
            DpInterfaceImpl.LogMessage("Expression:evaluate() called with null expression");
            return null;
        }
        if (objectArray == null) {
            return null;
        }
        return this.expression.Evaluate(objectArray, objectArray2, l, l2);
    }

    private void initializeTokenizer(String string) {
        this.characters = string.toCharArray();
        this.currentPos = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Token getToken(Hashtable hashtable) throws NeedInsertException, IllegalInsertException, InvalidExpressionException {
        Token token = new Token();
        try {
            while ((this.characters[this.currentPos] == ' ' || this.characters[this.currentPos] == '\t' || this.characters[this.currentPos] == '\n') && this.currentPos < this.characters.length) {
                ++this.currentPos;
            }
            switch (this.characters[this.currentPos]) {
                case '(': {
                    token.type = 5;
                    ++this.currentPos;
                    return token;
                }
                case ')': {
                    token.type = 6;
                    ++this.currentPos;
                    return token;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    token.length = 1;
                    token.begin = this.currentPos++;
                    token.type = 2;
                    return token;
                }
                case '!': 
                case '<': 
                case '=': 
                case '>': {
                    token.length = 1;
                    token.begin = this.currentPos++;
                    token.type = 2;
                    if (this.characters[this.currentPos] != '=') return token;
                    ++token.length;
                    ++this.currentPos;
                    return token;
                }
                case '&': {
                    token.length = 1;
                    token.begin = this.currentPos++;
                    token.type = 2;
                    if (this.characters[this.currentPos] != '&') return token;
                    ++token.length;
                    ++this.currentPos;
                    return token;
                }
                case '|': {
                    token.length = 1;
                    token.begin = this.currentPos++;
                    token.type = 2;
                    if (this.characters[this.currentPos] != '|') return token;
                    ++token.length;
                    ++this.currentPos;
                    return token;
                }
                case ',': {
                    token.length = 1;
                    token.begin = this.currentPos++;
                    token.type = 4;
                    return token;
                }
                case '?': {
                    token.length = 1;
                    token.begin = this.currentPos++;
                    token.type = 8;
                    return token;
                }
                case ':': {
                    token.length = 1;
                    token.begin = this.currentPos++;
                    token.type = 11;
                    return token;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    token.begin = this.currentPos;
                    token.type = 3;
                    while (this.characters[this.currentPos] >= '0' && this.characters[this.currentPos] <= '9') {
                        ++this.currentPos;
                    }
                    if (this.characters[this.currentPos] == '.') {
                        int n = 0;
                        token.type = 1;
                        while (this.characters[this.currentPos] >= '0' && this.characters[this.currentPos] <= '9' || this.characters[this.currentPos] == '.') {
                            if (this.characters[this.currentPos] == '.') {
                                ++n;
                            }
                            ++this.currentPos;
                        }
                        if (n == 1) {
                            token.type = 3;
                        } else if (token.type == 1 && this.characters[this.currentPos] == '*' && this.characters[this.currentPos - 1] == '.') {
                            ++this.currentPos;
                        } else if (token.type == 1 && this.characters[this.currentPos] == '$' && this.characters[this.currentPos - 1] == '.') {
                            ++this.currentPos;
                            while (Character.isDigit(this.characters[this.currentPos])) {
                                ++this.currentPos;
                            }
                        } else if (token.type == 1 && this.characters[this.currentPos] == '[' && this.characters[this.currentPos - 1] == '.') {
                            boolean bl = true;
                            token.string = new String(this.characters, token.begin, this.currentPos - token.begin);
                            this.defaultIndex = new String("");
                            while (this.characters[this.currentPos] == '[') {
                                int n2 = ++this.currentPos;
                                while (Character.isLetter(this.characters[this.currentPos]) || Character.isDigit(this.characters[this.currentPos])) {
                                    ++this.currentPos;
                                }
                                if (this.characters[this.currentPos] == ']') {
                                    if (bl) {
                                        String string = new String(this.characters, n2, this.currentPos - n2);
                                        if (hashtable == null) throw new NeedInsertException(string);
                                        Object v = hashtable.get(string);
                                        if (v != null) {
                                            this.defaultIndex = new String(String.valueOf(this.defaultIndex) + v);
                                            token.string = new String(String.valueOf(token.string) + v);
                                        } else {
                                            token.string = new String(String.valueOf(token.string) + ".*");
                                            bl = false;
                                        }
                                    }
                                } else {
                                    token.type = 0;
                                }
                                ++this.currentPos;
                                if (token.type != 1 || this.characters[this.currentPos] != '.') continue;
                                if (bl) {
                                    token.string = new String(String.valueOf(token.string) + ".");
                                }
                                this.defaultIndex = new String(String.valueOf(this.defaultIndex) + ".");
                                ++this.currentPos;
                            }
                            if (this.characters[this.currentPos] == '*') {
                                if (bl) {
                                    token.string = new String(String.valueOf(token.string) + ".*");
                                }
                                ++this.currentPos;
                            }
                            if (this.characters[this.currentPos] >= '0' && this.characters[this.currentPos] <= '9' || this.characters[this.currentPos] == '.') {
                                try {
                                    while (this.characters[this.currentPos] >= '0' && this.characters[this.currentPos] <= '9' || this.characters[this.currentPos] == '.') {
                                        ++this.currentPos;
                                    }
                                    throw new IllegalInsertException(new String(this.characters, token.begin, this.currentPos - token.begin));
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                                throw new IllegalInsertException(new String(this.characters, token.begin, this.currentPos - token.begin));
                            }
                        }
                    }
                    if (token.type == 3) {
                        token.value = new Float(new String(this.characters, token.begin, this.currentPos - token.begin)).floatValue();
                        return token;
                    } else {
                        token.length = this.currentPos - token.begin;
                    }
                    return token;
                }
                case '[': {
                    token.type = 12;
                    ++this.currentPos;
                    token.begin = this.currentPos;
                    while (Character.isLetter(this.characters[this.currentPos])) {
                        ++this.currentPos;
                    }
                    if (this.characters[this.currentPos] == ']') {
                        String string = new String(this.characters, token.begin, this.currentPos - token.begin);
                        if (hashtable == null) {
                            throw new NeedInsertException(string);
                        }
                        token.string = (String)hashtable.get(string);
                        ++this.currentPos;
                        return token;
                    } else {
                        token.type = 0;
                    }
                    return token;
                }
                default: {
                    if (Character.isLetter(this.characters[this.currentPos])) {
                        token.begin = this.currentPos;
                        while (Character.isLetter(this.characters[this.currentPos])) {
                            ++this.currentPos;
                        }
                        token.length = this.currentPos - token.begin;
                        switch (this.characters[token.begin]) {
                            case 'c': 
                            case 'd': 
                            case 'r': {
                                token.type = 7;
                                return token;
                            }
                            case 'i': {
                                token.type = 9;
                                return token;
                            }
                            case 't': {
                                token.type = 10;
                                return token;
                            }
                            case 'e': {
                                token.type = 11;
                                return token;
                            }
                            default: {
                                DpInterfaceImpl.LogMessage("encountered invalid word in expression : " + new String(this.characters, token.begin, token.length));
                                throw new InvalidExpressionException(new String(this.characters));
                            }
                        }
                    }
                    DpInterfaceImpl.LogMessage("encountered invalid character in expression : " + this.characters[this.currentPos]);
                    throw new InvalidExpressionException(new String(this.characters));
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (token.type == 1) {
                token.length = this.currentPos - token.begin;
                return token;
            }
            if (token.type == 3) {
                token.value = new Float(new String(this.characters, token.begin, this.currentPos - token.begin)).longValue();
                return token;
            }
            token.type = 4;
        }
        return token;
    }

    private Expr buildTree(Hashtable hashtable) throws NeedInsertException, IllegalInsertException, InvalidExpressionException {
        Expr expr;
        Token token;
        Expr expr2 = null;
        Token token2 = this.getToken(hashtable);
        if (token2 == null) {
            return null;
        }
        if (token2.type == 0) {
            return null;
        }
        if (token2.type == 4) {
            return null;
        }
        if (token2.type == 5) {
            expr2 = this.buildTree(hashtable);
            if (expr2 == null) {
                return null;
            }
            expr2.parenthesized = true;
        }
        if (token2.type == 9) {
            expr2 = this.buildTree(hashtable);
            if (expr2 == null) {
                DpInterfaceImpl.LogMessage("Expression:If condition is null");
                return null;
            }
            Expr expr3 = this.buildTree(hashtable);
            Expr expr4 = this.buildTree(hashtable);
            IfThenElse ifThenElse = new IfThenElse(expr2, expr3, expr4);
            return ifThenElse;
        }
        if (token2.type == 7) {
            token = this.getToken(hashtable);
            if (this.characters[token2.begin] == 'c') {
                expr2 = this.makeOperand(token, true);
            } else {
                expr = this.makeOperand(token);
                expr2 = new UnaryOperator(this.characters[token2.begin], expr);
            }
            expr = null;
        }
        if (token2.type == 1 || token2.type == 3 || expr2 != null) {
            token = this.getToken(hashtable);
            if (token.type == 2) {
                if (expr2 == null) {
                    expr2 = this.makeOperand(token2);
                }
                if ((expr = this.buildTree(hashtable)) == null) {
                    return null;
                }
                if (!expr.parenthesized && expr instanceof Operator && ((Operator)expr).lowerPriority(this.characters[token.begin])) {
                    Operator operator = new Operator(this.characters, token.begin, token.length, expr2, ((Operator)expr).operand1);
                    ((Operator)expr).operand1 = operator;
                    return expr;
                }
                if (expr instanceof IfThenElse) {
                    Operator operator = new Operator(this.characters, token.begin, token.length, expr2, ((IfThenElse)expr).condition);
                    ((IfThenElse)expr).condition = operator;
                    return expr;
                }
                Operator operator = new Operator(this.characters, token.begin, token.length, expr2, expr);
                return operator;
            }
            if (token.type == 8) {
                if (expr2 == null) {
                    expr2 = this.makeOperand(token2);
                }
                Expr expr5 = this.buildTree(hashtable);
                expr = this.buildTree(hashtable);
                IfThenElse ifThenElse = new IfThenElse(expr2, expr5, expr);
                return ifThenElse;
            }
            if (token.type == 4 || token.type == 6 || token.type == 10 || token.type == 11) {
                if (expr2 == null) {
                    expr2 = this.makeOperand(token2);
                }
                return expr2;
            }
            DpInterfaceImpl.LogMessage("invalid token sequence in expression");
            return null;
        }
        if (token2.type == 6) {
            DpInterfaceImpl.LogMessage("CLOSE PAREN??? HERE?????");
            return null;
        }
        DpInterfaceImpl.LogMessage("Expression:Invalid token encountered" + token2.toString());
        return null;
    }

    private Expr makeOperand(Token token) {
        return this.makeOperand(token, false);
    }

    private Expr makeOperand(Token token, boolean bl) {
        Expr expr = bl ? new ConstOperand(this.characters, token) : (token.type == 1 ? new Operand(this.characters, token.begin, token.length, this.oiList.addOI(token, this.characters), this.oiList) : new ConstOperand(token.value));
        return expr;
    }

    public String toString() {
        return this.expression.toString();
    }

    public void printTree() {
        System.out.println(this.expression);
    }
}

